* Everything for the fans: Party responsiveness across the EU over time
* Felix Lehmann
* Department of Political Science, University of Gothenburg
* felix.lehmann@gu.se; Sprängkullsgatan 19, Box 711, 411 23 Göteborg, Sweden

* Replication file for the appendix


* save all replication files in the same folder structure
* change the working directory to the designated folder structure
*cd "C:\..."

cd "C:\Users\xlehfe\OneDrive - University of Gothenburg\1Dissertation\Everything for the fans research note\Replication files"


* Table A3

use "Everything_for_the_fans_data2.dta", clear

* descriptives and distributions of measures, especially public opinion shifts and party shifts (look at Jon's paper)

asdoc sum lrgen_position_change immigration_position_change eu_position_change redistribution_position_change sociallifestyle_position_change environment_position_change civlib_laworder_position_change voter_party_gap_lr_lag voter_party_gap_imm_lag voter_party_gap_eu_lag voter_party_gap_red_lag voter_party_gap_ssm_lag  voter_party_gap_env_lag voter_party_gap_lo_lag supporter_party_gap_lr_lag supporter_party_gap_imm_lag supporter_party_gap_eu_lag supporter_party_gap_red_lag supporter_party_gap_ssm_lag supporter_party_gap_env_lag supporter_party_gap_lo_lag nopart_party_gap_lr_lag nopart_party_gap_imm_lag nopart_party_gap_eu_lag nopart_party_gap_red_lag nopart_party_gap_ssm_lag nopart_party_gap_env_lag nopart_party_gap_lo_lag lr_public_change_ees immigration_public_change_ees eu_public_change_ees redist_public_change_ees ssm_public_change_ees environment_public_change_ees order_public_change_ees lr_public_supp_change_ees imm_public_supp_change_ees eu_public_supp_change_ees redist_public_supp_change_ees ssm_public_supp_change_ees env_public_supp_change_ees order_public_supp_change_ees lr_public_nopart_change_ees imm_public_nopart_change_ees eu_public_nopart_change_ees redist_public_nopart_change_ees ssm_public_nopart_change_ees env_public_nopart_change_ees order_public_nopart_change_ees, label replace dec(2) save(Table 1) title()

use "Everything_for_the_fans_data.dta", clear

gen party2 = party if voter_party_gap_lag > 4 & position_change >= 4
replace party2 = party if position_change <= -1.9
replace party2 = party if position_change >= 1.9

drop if position_change > 4
drop if position_change < -4
drop if voter_party_gap_lag > 6
drop if voter_party_gap_lag < -6

sc position_change voter_party_gap_lag if issue == 14, msymbol(Oh)|| lfit position_change voter_party_gap_lag if issue == 14, title("{bf:Left-right}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Left-right party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g1, replace

sc position_change voter_party_gap_lag if issue == 5, msymbol(Oh) || lfit position_change voter_party_gap_lag if issue == 5, title("{bf:Immigration}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Immigration party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g1, replace
sc position_change voter_party_gap_lag if issue == 1, msymbol(Oh) || lfit position_change voter_party_gap_lag if issue == 1, title("{bf:EU}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ EU party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g2, replace
sc position_change voter_party_gap_lag if issue == 7, msymbol(Oh) || lfit position_change voter_party_gap_lag if issue == 7, title("{bf:Redistribution}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Redistribution party position") mlabel(party2) lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g3, replace
sc position_change voter_party_gap_lag if issue == 9, msymbol(Oh) || lfit position_change voter_party_gap_lag if issue == 9, title("{bf:Social lifestyle}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Social lifestyle party position") mlabel(party2) lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g4, replace
sc position_change voter_party_gap_lag if issue == 6, msymbol(Oh) || lfit position_change voter_party_gap_lag if issue == 6, title("{bf:Environment}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Environment party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g5, replace
sc position_change voter_party_gap_lag if issue == 8, msymbol(Oh) || lfit position_change voter_party_gap_lag if issue == 8, title("{bf:Law and order}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Law and order party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g6, replace 

graph combine "g1" "g2" "g3" "g4" "g5" "g6", col(3) title((A) Voter gap and Δ party position, margin(b=1) size(large))

graph export "figa4a.png", replace

* Note cuts off all cases with gaps higher than -6 and position changes higher than 4

use "Everything_for_the_fans_data.dta", clear

gen party2 = party if voter_party_gap_lag > 4 & position_change >= 4
replace party2 = party if position_change <= -1.9
replace party2 = party if position_change >= 1.9

drop if position_change > 4
drop if position_change < -4
drop if public_change_ees > 4
drop if public_change_ees < -4

sc position_change public_change_ees if issue == 14, msymbol(Oh)|| lfit position_change public_change_ees if issue == 14, title("{bf:Left-right}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Left-right party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g1, replace

sc position_change public_change_ees if issue == 5, msymbol(Oh) || lfit position_change public_change_ees if issue == 5, title("{bf:Immigration}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Immigration party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g1, replace
sc position_change public_change_ees if issue == 1, msymbol(Oh) || lfit position_change public_change_ees if issue == 1, title("{bf:EU}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ EU party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g2, replace
sc position_change public_change_ees if issue == 7, msymbol(Oh) || lfit position_change public_change_ees if issue == 7, title("{bf:Redistribution}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Redistribution party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g3, replace
sc position_change public_change_ees if issue == 9, msymbol(Oh) || lfit position_change public_change_ees if issue == 9, title("{bf:Social lifestyle}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Social lifestyle party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g4, replace
sc position_change public_change_ees if issue == 6, msymbol(Oh) || lfit position_change public_change_ees if issue == 6, title("{bf:Environment}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Environment party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g5, replace
sc position_change public_change_ees if issue == 8, msymbol(Oh) || lfit position_change public_change_ees if issue == 8, title("{bf:Law and order}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Law and order party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g6, replace

graph combine "g1" "g2" "g3" "g4" "g5" "g6", col(3) title((B) Δ Voter and Δ party position, margin(b=1) size(large))

graph export "figa4b.png", replace

use "Everything_for_the_fans_data.dta", clear

gen party2 = party if voter_party_gap_lag > 4 & position_change >= 4
replace party2 = party if position_change <= -1.9
replace party2 = party if position_change >= 1.9

drop if position_change > 4
drop if position_change < -4
drop if supporter_party_gap_lag > 6
drop if supporter_party_gap_lag < -6

sc position_change supporter_party_gap_lag if issue == 14, msymbol(Oh)|| lfit position_change supporter_party_gap_lag if issue == 14, title("{bf:Left-right}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Left-right party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g1, replace

sc position_change supporter_party_gap_lag if issue == 5, msymbol(Oh) || lfit position_change supporter_party_gap_lag if issue == 5, title("{bf:Immigration}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Immigration party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g1, replace
sc position_change supporter_party_gap_lag if issue == 1, msymbol(Oh) || lfit position_change supporter_party_gap_lag if issue == 1, title("{bf:EU}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ EU party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g2, replace
sc position_change supporter_party_gap_lag if issue == 7, msymbol(Oh) || lfit position_change supporter_party_gap_lag if issue == 7, title("{bf:Redistribution}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Redistribution party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g3, replace
sc position_change supporter_party_gap_lag if issue == 9, msymbol(Oh) || lfit position_change supporter_party_gap_lag if issue == 9, title("{bf:Social lifestyle}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Social lifestyle party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g4, replace
sc position_change supporter_party_gap_lag if issue == 6, msymbol(Oh) || lfit position_change supporter_party_gap_lag if issue == 6, title("{bf:Environment}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Environment party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g5, replace
sc position_change supporter_party_gap_lag if issue == 8, msymbol(Oh) || lfit position_change supporter_party_gap_lag if issue == 8, title("{bf:Law and order}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-6 (2) 6) legend(off) ytitle("Δ Law and order party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g6, replace

graph combine "g1" "g2" "g3" "g4" "g5" "g6", col(3) title((C) Supporter gap and Δ party position, margin(b=1) size(large))

graph export "figa4c.png", replace

* Note cuts off all cases with gaps higher than -6 and position changes higher than 4

use "Everything_for_the_fans_data.dta", clear

gen party2 = party if voter_party_gap_lag > 4 & position_change >= 4
replace party2 = party if position_change <= -1.9
replace party2 = party if position_change >= 1.9

drop if position_change > 4
drop if position_change < -4
drop if public_change_supp_ees > 4
drop if public_change_supp_ees < -4

sc position_change public_change_supp_ees if issue == 14, msymbol(Oh)|| lfit position_change public_change_supp_ees if issue == 14, title("{bf:Left-right}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Left-right party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g1, replace

sc position_change public_change_ees if issue == 5, msymbol(Oh) || lfit position_change public_change_supp_ees if issue == 5, title("{bf:Immigration}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Immigration party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g1, replace
sc position_change public_change_supp_ees if issue == 1, msymbol(Oh) || lfit position_change public_change_supp_ees if issue == 1, title("{bf:EU}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ EU party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g2, replace
sc position_change public_change_supp_ees if issue == 7, msymbol(Oh) || lfit position_change public_change_supp_ees if issue == 7, title("{bf:Redistribution}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Redistribution party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g3, replace
sc position_change public_change_supp_ees if issue == 9, msymbol(Oh) || lfit position_change public_change_supp_ees if issue == 9, title("{bf:Social lifestyle}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Social lifestyle party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g4, replace
sc position_change public_change_supp_ees if issue == 6, msymbol(Oh) || lfit position_change public_change_supp_ees if issue == 6, title("{bf:Environment}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Environment party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g5, replace
sc position_change public_change_supp_ees if issue == 8, msymbol(Oh) || lfit position_change public_change_supp_ees if issue == 8, title("{bf:Law and order}") lwidth(thick) ylabel(-4 (2) 4)  xlabel(-4 (2) 4) legend(off) ytitle("Δ Law and order party position") lpattern(solid) mcolor(gs0) lcolor(dknavy) msize(small)
graph save g6, replace

graph combine "g1" "g2" "g3" "g4" "g5" "g6", col(3) title((D) Δ Supporter and Δ party position, margin(b=1) size(large))

graph export "figa4d.png", replace

* Appendix B
* Table B1 - public responsiveness full regression tables
use "Everything_for_the_fans_data.dta", clear

eststo clear
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 14
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 7
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 9
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using b1.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs" "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc) keep(public_change_ees voter_party_gap_lag _cons)

* Table B2
eststo clear
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 14
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 7
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 9
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using b2.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs"  "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc)

* Table B3
eststo clear
eststo: qui: reg position_change supporter_party_gap_lag voter_party_gap_lag public_change_supp_ees public_change_ees if issue == 14
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag voter_party_gap_lag public_change_supp_ees public_change_ees if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag voter_party_gap_lag public_change_supp_ees public_change_ees if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag voter_party_gap_lag public_change_supp_ees public_change_ees if issue == 7
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag voter_party_gap_lag public_change_supp_ees public_change_ees if issue == 9
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag voter_party_gap_lag public_change_supp_ees public_change_ees if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag voter_party_gap_lag public_change_supp_ees public_change_ees if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using b3.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs"  "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc)


* Table B4
eststo clear
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 14
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 7
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 9
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using b4.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs"  "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc)

* Table B5
eststo clear
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 14
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 7
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 9
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using b5.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs"  "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc)

* Table B6
eststo clear
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.supporter_party_gap_lag i.wecee#c.nopart_party_gap_lag if issue == 14
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.supporter_party_gap_lag i.wecee#c.nopart_party_gap_lag if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.supporter_party_gap_lag i.wecee#c.nopart_party_gap_lag if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.supporter_party_gap_lag i.wecee#c.nopart_party_gap_lag if issue == 7
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.supporter_party_gap_lag i.wecee#c.nopart_party_gap_lag if issue == 9
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.supporter_party_gap_lag i.wecee#c.nopart_party_gap_lag if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.supporter_party_gap_lag i.wecee#c.nopart_party_gap_lag if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using b6.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs"  "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc)

* Table B7
eststo clear
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.public_change_supp_ees i.wecee#c.public_change_nopart_ees if issue == 14
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.public_change_supp_ees i.wecee#c.public_change_nopart_ees if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.public_change_supp_ees i.wecee#c.public_change_nopart_ees if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.public_change_supp_ees i.wecee#c.public_change_nopart_ees if issue == 7
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.public_change_supp_ees i.wecee#c.public_change_nopart_ees if issue == 9
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.public_change_supp_ees i.wecee#c.public_change_nopart_ees if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.wecee i.wecee#c.public_change_supp_ees i.wecee#c.public_change_nopart_ees if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using b7.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs"  "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc)


* Figure B1

eststo clear
eststo: qui: reg position_change supporter_party_gap_lag public_change_supp_ees if issue == 14
estimate store lr
eststo: qui: reg position_change supporter_party_gap_lag public_change_supp_ees if issue == 5
estimate store imm
eststo: qui: reg position_change supporter_party_gap_lag public_change_supp_ees if issue == 1
estimate store eu
eststo: qui: reg position_change supporter_party_gap_lag public_change_supp_ees if issue == 7
estimate store redist
eststo: qui: reg position_change supporter_party_gap_lag public_change_supp_ees if issue == 9
estimate store social
eststo: qui: reg position_change supporter_party_gap_lag public_change_supp_ees if issue == 6
estimate store env
eststo: qui: reg position_change supporter_party_gap_lag public_change_supp_ees if issue == 8
estimate store law

set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")) (law, aseq("Law and order")) || , keep(supporter_party_gap_lag public_change_supp_ees) ///
 swapnames eqlabels("{bf:Supporter gap}" "{bf:Δ Supporter}", angle(90)) ///
 aseq levels(90) ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position)  ///
 legend(off) mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))  mlabposition(12) grid(none) msymbol(s) color(blue) title("{bf:(A) Partisan constituency}", margin(b=5) size(med))


graph save "g1", replace

eststo clear
eststo: qui: reg position_change nopart_party_gap_lag public_change_nopart_ees if issue == 14
estimate store lr
eststo: qui: reg position_change nopart_party_gap_lag public_change_nopart_ees if issue == 5
estimate store imm
eststo: qui: reg position_change nopart_party_gap_lag public_change_nopart_ees if issue == 1
estimate store eu
eststo: qui: reg position_change nopart_party_gap_lag public_change_nopart_ees if issue == 7
estimate store redist
eststo: qui: reg position_change nopart_party_gap_lag public_change_nopart_ees if issue == 9
estimate store social
eststo: qui: reg position_change nopart_party_gap_lag public_change_nopart_ees if issue == 6
estimate store env
eststo: qui: reg position_change nopart_party_gap_lag public_change_nopart_ees if issue == 8
estimate store law

set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")) (law, aseq("Law and order")) || , keep(nopart_party_gap_lag public_change_nopart_ees) ///
 swapnames eqlabels("{bf:Non-supporter gap}" "{bf:Δ Non-supporter}", angle(90)) ///
 aseq levels(90) ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position)  ///
 legend(off) mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))  mlabposition(12) grid(none) msymbol(s) color(blue) title("{bf:(B) General electorate}", margin(b=5) size(med))

graph save "g2", replace 

graph combine "g1" "g2", caption("90% CIs; + p < 0.1, * p < 0.05, ** p < 0.01, *** p < 0.001", position(5) justification(right) size(vsmall))

graph export "figb1.png", replace

* Figure B2

eststo clear
eststo: qui: reg position_change supporter_party_gap_lag if issue == 14
estimate store lr
eststo: qui: reg position_change supporter_party_gap_lag if issue == 5
estimate store imm
eststo: qui: reg position_change supporter_party_gap_lag if issue == 1
estimate store eu
eststo: qui: reg position_change supporter_party_gap_lag if issue == 7
estimate store redist
eststo: qui: reg position_change supporter_party_gap_lag if issue == 9
estimate store social
eststo: qui: reg position_change supporter_party_gap_lag if issue == 6
estimate store env
eststo: qui: reg position_change supporter_party_gap_lag if issue == 8
estimate store law

set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")) (law, aseq("Law and order")) || , keep(supporter_party_gap_lag) ///
 swapnames eqlabels("{bf:Supporter gap}" "{bf:Δ Supporter}", angle(90)) ///
 aseq ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position)  ///
 legend(off) mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))  mlabposition(12) grid(none) msymbol(s) color(blue) title("{bf:(A) Partisan constituency (congruent)}", margin(b=5) size(med)) xlabel(0 (0.1) 0.3) xsc(r(-0 0.3))


graph save "g1", replace

eststo clear
eststo: qui: reg position_change public_change_supp_ees if issue == 14
estimate store lr
eststo: qui: reg position_change public_change_supp_ees if issue == 5
estimate store imm
eststo: qui: reg position_change public_change_supp_ees if issue == 1
estimate store eu
eststo: qui: reg position_change public_change_supp_ees if issue == 7
estimate store redist
eststo: qui: reg position_change public_change_supp_ees if issue == 9
estimate store social
eststo: qui: reg position_change public_change_supp_ees if issue == 6
estimate store env
eststo: qui: reg position_change public_change_supp_ees if issue == 8
estimate store law

set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")) (law, aseq("Law and order")) || , keep( public_change_supp_ees) ///
 swapnames eqlabels("{bf:Supporter gap}" "{bf:Δ Supporter}", angle(90)) ///
 aseq levels(90) ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position)  ///
 legend(off) mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))  mlabposition(12) grid(none) msymbol(s) color(blue) title("{bf:(B) Partisan constituency (standard)}", margin(b=5) size(med)) xlabel(-0.3 (0.1) 0.3) xsc(r(-0.3 0.3))


graph save "g2", replace

eststo clear
eststo: qui: reg position_change nopart_party_gap_lag if issue == 14
estimate store lr
eststo: qui: reg position_change nopart_party_gap_lag if issue == 5
estimate store imm
eststo: qui: reg position_change nopart_party_gap_lag if issue == 1
estimate store eu
eststo: qui: reg position_change nopart_party_gap_lag if issue == 7
estimate store redist
eststo: qui: reg position_change nopart_party_gap_lag if issue == 9
estimate store social
eststo: qui: reg position_change nopart_party_gap_lag if issue == 6
estimate store env
eststo: qui: reg position_change nopart_party_gap_lag if issue == 8
estimate store law

set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")) (law, aseq("Law and order")) || , keep(nopart_party_gap_lag) ///
 swapnames eqlabels("{bf:Non-supporter gap}" "{bf:Δ Non-supporter}", angle(90)) ///
 aseq levels(90) ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position)  ///
 legend(off) mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))  mlabposition(12) grid(none) msymbol(s) color(blue) title("{bf:(C) General electorate (congruent)}", margin(b=5) size(med)) xlabel(0 (0.1) 0.3) xsc(r(-0 0.3))

graph save "g3", replace 

eststo clear
eststo: qui: reg position_change public_change_nopart_ees if issue == 14
estimate store lr
eststo: qui: reg position_change public_change_nopart_ees if issue == 5
estimate store imm
eststo: qui: reg position_change public_change_nopart_ees if issue == 1
estimate store eu
eststo: qui: reg position_change public_change_nopart_ees if issue == 7
estimate store redist
eststo: qui: reg position_change public_change_nopart_ees if issue == 9
estimate store social
eststo: qui: reg position_change public_change_nopart_ees if issue == 6
estimate store env
eststo: qui: reg position_change public_change_nopart_ees if issue == 8
estimate store law

set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")) (law, aseq("Law and order")) || , keep( public_change_nopart_ees) ///
 swapnames eqlabels("{bf:Non-supporter gap}" "{bf:Δ Non-supporter}", angle(90)) ///
 aseq levels(90) ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position)  ///
 legend(off) mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))  mlabposition(12) grid(none) msymbol(s) color(blue) title("{bf:(D) General electorate (standard)}", margin(b=5) size(med)) xlabel(-0.3 (0.1) 0.3) xsc(r(-0.3 0.3))

graph save "g4", replace 

graph combine "g1" "g2" "g3" "g4",  caption("90% CIs; + p < 0.1, * p < 0.05, ** p < 0.01, *** p < 0.001", position(5) justification(right) size(vsmall))

graph export "figb2.png", replace


* Figure B3

set scheme s1mono
eststo clear
// Left-right

eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 14
margins, dydx(voter_party_gap_lag) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Supporter gap}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g1lr, replace

// Immigration
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 5
margins, dydx(voter_party_gap_lag) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 1
margins, dydx(voter_party_gap_lag) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 7
margins, dydx(voter_party_gap_lag) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 9
margins, dydx(voter_party_gap_lag) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 6
margins, dydx(voter_party_gap_lag) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g6, replace

// Law and order
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 8
margins, dydx(voter_party_gap_lag) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Law and order}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((A) Voter gap, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "figb3a.png", replace


set scheme s1mono
eststo clear
// Left-right

eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 14
margins, dydx(public_change_ees) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Supporter gap}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 0.6) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g1lr, replace

// Immigration
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 5
margins, dydx(public_change_ees) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 0.6) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 1
margins, dydx(public_change_ees) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 0.6) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 7
margins, dydx(public_change_ees) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 0.6) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 9
margins, dydx(public_change_ees) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 0.6) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 6
margins, dydx(public_change_ees) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 0.6) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g6, replace

// Law and order
eststo: reg position_change public_change_ees voter_party_gap_lag i.wecee i.wecee#c.voter_party_gap_lag i.wecee#c.public_change_ees if issue == 8
margins, dydx(public_change_ees) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Law and order}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 0.6) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((B) Δ Voter, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "figb3b.png", replace

* Figure B4
* Yearly estimates

set scheme s1mono
eststo clear
// Left-right

eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 14
margins, dydx(voter_party_gap_lag) at(year=(2006 2010 2014 2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Left-right}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.1) 0.4) ///
mlabels(1._at = 3 "2006" 2._at = 3 "2010" 3._at =  3 "2014" 4._at =  3 "2019" 5._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g1, replace

// Immigration
eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 5
margins, dydx(voter_party_gap_lag) at(year=(2014 2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "2014" 2._at =  3 "2019" 3._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 1
margins, dydx(voter_party_gap_lag) at(year=(2006 2010 2014 2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "2006" 2._at = 3 "2010" 3._at =  3 "2014" 4._at =  3 "2019" 5._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 7
margins, dydx(voter_party_gap_lag) at(year=(2014 2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "2014" 2._at =  3 "2019" 3._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 9
margins, dydx(voter_party_gap_lag) at(year=(2014 2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at = 3 "2014" 2._at =  3 "2019" 3._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 6
margins, dydx(voter_party_gap_lag) at(year=(2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 0.4) ///
mlabels(1._at =  3 "2019" 2._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g6, replace

graph combine "g1" "g2" "g3" "g4" "g5" "g6", col(3) title((A) Voter gap, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "figb4a.png", replace

set scheme s1mono
eststo clear
// Left-right

eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 14
margins, dydx(public_change_ees) at(year=(2006 2010 2014 2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Left-right}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 1) ///
mlabels(1._at = 3 "2006" 2._at = 3 "2010" 3._at =  3 "2014" 4._at =  3 "2019" 5._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue)
graph save g1, replace

// Immigration
eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 5
margins, dydx(public_change_ees) at(year=(2014 2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 1) ///
mlabels(1._at = 3 "2014" 2._at =  3 "2019" 3._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 1
margins, dydx(public_change_ees) at(year=(2006 2010 2014 2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 1) ///
mlabels(1._at = 3 "2006" 2._at = 3 "2010" 3._at =  3 "2014" 4._at =  3 "2019" 5._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 7
margins, dydx(public_change_ees) at(year=(2014 2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 1) ///
mlabels(1._at = 3 "2014" 2._at =  3 "2019" 3._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 9
margins, dydx(public_change_ees) at(year=(2014 2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 1) ///
mlabels(1._at = 3 "2014" 2._at =  3 "2019" 3._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_ees voter_party_gap_lag i.year i.year#c.public_change_ees i.year#c.voter_party_gap_lag if issue == 6
margins, dydx(public_change_ees) at(year=(2019 2024)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.6 (0.2) 1) ///
mlabels(1._at =  3 "2019" 2._at =  3 "2024") mlabsize(small) ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g6, replace

graph combine "g1" "g2" "g3" "g4" "g5" "g6", col(3) title((B) Δ Voter, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "figb4b.png", replace

* Figure B5

set scheme s1mono
eststo clear
// Left-right

eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.wecee i.wecee#c.supporter_party_gap_lag i.wecee#c.nopart_party_gap_lag if issue == 14
margins, dydx(supporter_party_gap_lag) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Supporter gap}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g1lr, replace
// Left-right

eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.wecee i.wecee#c.supporter_party_gap_lag i.wecee#c.nopart_party_gap_lag if issue == 14
margins, dydx(nopart_party_gap_lag) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Non-supporter gap}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g2lr, replace
// Left-right

eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.wecee i.wecee#c.public_change_supp_ees i.wecee#c.public_change_nopart_ees if issue == 14
margins, dydx(public_change_supp_ees) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Δ Supporter}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3lr, replace
// Left-right

eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.wecee i.wecee#c.public_change_supp_ees i.wecee#c.public_change_nopart_ees if issue == 14
margins, dydx(public_change_nopart_ees) at(wecee=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Δ Non-supporter}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "CEE" 2._at =  3 "WE") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4lr, replace

* LR graph
graph combine  "g1lr" "g2lr" "g3lr" "g4lr", col(2) title(Left-right responsiveness, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "figb5.png", replace

* Table B8
eststo clear
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.supporter_party_gap_lag i.year#c.nopart_party_gap_lag if issue == 14
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.supporter_party_gap_lag i.year#c.nopart_party_gap_lag if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.supporter_party_gap_lag i.year#c.nopart_party_gap_lag if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.supporter_party_gap_lag i.year#c.nopart_party_gap_lag if issue == 7
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.supporter_party_gap_lag i.year#c.nopart_party_gap_lag if issue == 9
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.supporter_party_gap_lag i.year#c.nopart_party_gap_lag if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.supporter_party_gap_lag i.year#c.nopart_party_gap_lag if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using b8.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs"  "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc)

* Table B9
eststo clear
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.public_change_supp_ees i.year#c.public_change_nopart_ees if issue == 14
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.public_change_supp_ees i.year#c.public_change_nopart_ees if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.public_change_supp_ees i.year#c.public_change_nopart_ees if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.public_change_supp_ees i.year#c.public_change_nopart_ees if issue == 7
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.public_change_supp_ees i.year#c.public_change_nopart_ees if issue == 9
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.public_change_supp_ees i.year#c.public_change_nopart_ees if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees i.year i.year#c.public_change_supp_ees i.year#c.public_change_nopart_ees if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using b9.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs"  "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc)

* Appendix C - robustness checks
* Table C1 - public responsiveness with LDV and country FEs

eststo clear
eststo: qui: reghdfe position_change voter_party_gap_lag public_change_ees position_change_lag i.country if issue == 14, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_ees voter_party_gap_lag position_change_lag i.country if issue == 5, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_ees voter_party_gap_lag position_change_lag i.country if issue == 1, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_ees voter_party_gap_lag position_change_lag i.country if issue == 7, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_ees voter_party_gap_lag position_change_lag i.country if issue == 9, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_ees voter_party_gap_lag position_change_lag i.country if issue == 6, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_ees voter_party_gap_lag position_change_lag i.country if issue == 8, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"

esttab using c1.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs" "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc) keep(public_change_ees voter_party_gap_lag position_change_lag _cons)

* Table C2 - public responsiveness with LDV and country FEs

eststo clear
eststo: qui: reghdfe position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees position_change_lag if issue == 14, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag position_change_lag if issue == 5, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag position_change_lag if issue == 1, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag position_change_lag if issue == 7, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag position_change_lag if issue == 9, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag position_change_lag if issue == 6, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"
eststo: qui: reghdfe position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag position_change_lag if issue == 8, absorb(country) cluster(election_id)
estadd local country "Yes"
estadd local cluster "Yes"

esttab using c2.rtf, replace label varwidth(18) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs" "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(LR Imm EU Redist Social Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc) keep(public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag position_change_lag _cons)

* Table C3 - aggregate model

eststo clear
eststo: qui: reghdfe position_change voter_party_gap_lag public_change_ees if issue == 5 | issue == 6 | issue == 1 | issue == 8 | issue == 7 | issue == 9, noabsorb
estadd local country "No"
estadd local issue "No"
estadd local cluster "No"
estadd local LDV "No"
eststo: qui: reghdfe position_change public_change_ees voter_party_gap_lag position_change_lag if issue == 5 | issue == 6 | issue == 1 | issue == 8 | issue == 7 | issue == 9, cluster(party_id election_id) noabsorb
estadd local country "No"
estadd local issue "No"
estadd local cluster "Yes"
estadd local LDV "Yes"
eststo: qui: reghdfe position_change public_change_ees voter_party_gap_lag position_change_lag if issue == 5 | issue == 6 | issue == 1 | issue == 8 | issue == 7 | issue == 9, cluster(party_id election_id) absorb(issue country)
estadd local country "Yes"
estadd local issue "Yes"
estadd local cluster "Yes"
estadd local LDV "Yes"

esttab using c3.rtf, replace label varwidth(20) se modelwidth(5) compress nogap onecell stats(N country issue cluster LDV, fmt(a2) label ("Observations" "Country FEs" "Issue FEs" "Two-way clustered SEs" "LDV")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(1 2 3 4 5 6) note("Notes: Estimates from pooled multivariate regression models. The dependent variable is the change in the party's position. The standard errors are clustered on the party- and survey-wave-level") b(%9.3fc) drop(position_change_lag _cons)


* Table C4 - aggregate model

eststo clear
eststo: qui: reghdfe position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 5 | issue == 6 | issue == 1 | issue == 8 | issue == 7 | issue == 9, noabsorb
estadd local country "No"
estadd local issue "No"
estadd local cluster "No"
estadd local LDV "No"
eststo: qui: reghdfe position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag position_change_lag if issue == 5 | issue == 6 | issue == 1 | issue == 8 | issue == 7 | issue == 9, cluster(party_id election_id) noabsorb
estadd local country "No"
estadd local issue "No"
estadd local cluster "Yes"
estadd local LDV "Yes"
eststo: qui: reghdfe position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag position_change_lag if issue == 5 | issue == 6 | issue == 1 | issue == 8 | issue == 7 | issue == 9, cluster(party_id election_id) absorb(issue country)
estadd local country "Yes"
estadd local issue "Yes"
estadd local cluster "Yes"
estadd local LDV "Yes"

esttab using c4.rtf, replace label varwidth(20) se modelwidth(5) compress nogap onecell stats(N country issue cluster LDV, fmt(a2) label ("Observations" "Country FEs" "Issue FEs" "Two-way clustered SEs" "LDV")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(1 2 3 4 5 6) note("Notes: Estimates from pooled multivariate regression models. The dependent variable is the change in the party's position. The standard errors are clustered on the party- and survey-wave-level") b(%9.3fc) drop(position_change_lag _cons)

* Appendix D
* Table D1

eststo clear
eststo: qui: reg position_change public_change_ees voter_party_gap_lag migrant_inflow_lag1_log if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change public_change_ees voter_party_gap_lag i.eurozone_crisis if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change public_change_ees voter_party_gap_lag unemployment_lag1 gdp_cap_growth_lag1 if issue == 7
estadd local country "No"
estadd local cluster "No"
*eststo: qui: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag if issue == 9
eststo: qui: reg position_change public_change_ees voter_party_gap_lag co2_cap if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change public_change_ees voter_party_gap_lag homocides if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using d1.rtf, replace label varwidth(21) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs" "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(Imm EU Redist Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc) 


* Table D2
* Are parties just responsive to objective conditions?

eststo clear
eststo: qui: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag migrant_inflow_lag1_log if issue == 5
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.eurozone_crisis if issue == 1
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag unemployment_lag1 gdp_cap_growth_lag1 if issue == 7
estadd local country "No"
estadd local cluster "No"
*eststo: qui: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag if issue == 9
eststo: qui: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag co2_cap if issue == 6
estadd local country "No"
estadd local cluster "No"
eststo: qui: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag homocides if issue == 8
estadd local country "No"
estadd local cluster "No"

esttab using d2.rtf, replace label varwidth(21) se modelwidth(5) compress nogap onecell stats(N country cluster, fmt(a2) label ("Observations" "Country FEs" "Clustered SEs")) star (+ 0.1 * 0.05 ** 0.01 *** 0.001) nonumbers mtitles(Imm EU Redist Env Law) note("Notes: Estimates from multivariate regression models. The dependent variable is the change in the party's position on the respective issue.") b(%9.3fc) 


* Appendix E - The role of party type


* Figure E1
set scheme s1mono
eststo clear
// Left-right
	
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 14
margins, dydx(supporter_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Supporter gap}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g1lr, replace
// Left-right

eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 14
margins, dydx(nopart_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Non-supporter gap}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g2lr, replace
// Left-right

eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 14
margins, dydx(public_change_supp_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Δ Supporter}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3lr, replace
// Left-right

eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 14
margins, dydx(public_change_nopart_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Δ Non-supporter}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4lr, replace

* LR graph
graph combine  "g1lr" "g2lr" "g3lr" "g4lr", col(2) title(Left-right responsiveness, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige1.png", replace

* Figure E2
* main niche definition but only WE parties

set scheme s1mono
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 5 & wecee == 1
margins, dydx(supporter_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 1 & wecee == 1
margins, dydx(supporter_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 7 & wecee == 1
margins, dydx(supporter_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 9 & wecee == 1
margins, dydx(supporter_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 6 & wecee == 1
margins, dydx(supporter_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g6, replace

// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 8 & wecee == 1
margins, dydx(supporter_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Law and order}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((A) Supporter gap, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige2a.png", replace


set scheme s1mono
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 5 & wecee == 1
margins, dydx(nopart_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 1 & wecee == 1
margins, dydx(nopart_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 7 & wecee == 1
margins, dydx(nopart_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 9 & wecee == 1
margins, dydx(nopart_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 6 & wecee == 1
margins, dydx(nopart_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g6, replace

// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.supporter_party_gap_lag i.mainstream_econ#c.nopart_party_gap_lag if issue == 8 & wecee == 1
margins, dydx(nopart_party_gap_lag) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Law and order}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((B) Non-supporter gap, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige2b.png", replace

set scheme s1mono
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 5 & wecee == 1
margins, dydx(public_change_supp_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 1 & wecee == 1
margins, dydx(public_change_supp_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 7 & wecee == 1
margins, dydx(public_change_supp_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 9 & wecee == 1
margins, dydx(public_change_supp_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 6 & wecee == 1
margins, dydx(public_change_supp_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g6, replace

// Law and order
	eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 8 & wecee == 1
	margins, dydx(public_change_supp_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Law and order}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((C) Δ Supporter, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige2c.png", replace


set scheme s1mono
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 5 & wecee == 1
margins, dydx(public_change_nopart_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 1 & wecee == 1
margins, dydx(public_change_nopart_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 7 & wecee == 1
margins, dydx(public_change_nopart_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 9 & wecee == 1
margins, dydx(public_change_nopart_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 6 & wecee == 1
margins, dydx(public_change_nopart_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g6, replace

// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_econ i.mainstream_econ#c.public_change_supp_ees i.mainstream_econ#c.public_change_nopart_ees if issue == 8 & wecee == 1
margins, dydx(public_change_nopart_ees) at(mainstream_econ=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Law and order}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((D) Δ Non-supporter, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige2d.png", replace


* Figure E3
* Adams et al. 2006 niche definition

set scheme s1mono
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 5
margins, dydx(supporter_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 1
margins, dydx(supporter_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 7
margins, dydx(supporter_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 9
margins, dydx(supporter_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 6
margins, dydx(supporter_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g6, replace

// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 8
margins, dydx(supporter_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Law and order}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((A) Supporter gap, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige3a.png", replace


set scheme s1mono
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 5
margins, dydx(nopart_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 1
margins, dydx(nopart_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 7
margins, dydx(nopart_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 9
margins, dydx(nopart_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 6
margins, dydx(nopart_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g6, replace

// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.supporter_party_gap_lag i.mainstream_narrow#c.nopart_party_gap_lag if issue == 8
margins, dydx(nopart_party_gap_lag) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Law and order}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(s) color(blue) 
graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((B) Non-supporter gap, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige3b.png", replace

set scheme s1mono
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 5
margins, dydx(public_change_supp_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 1
margins, dydx(public_change_supp_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 7
margins, dydx(public_change_supp_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 9
margins, dydx(public_change_supp_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 6
margins, dydx(public_change_supp_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g6, replace

// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 8
margins, dydx(public_change_supp_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Law and order}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-0.2 (0.2) 1.2) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((C) Δ Supporter, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige3c.png", replace

set scheme s1mono
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 5
margins, dydx(public_change_nopart_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Immigration}")  yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g2, replace

// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 1
margins, dydx(public_change_nopart_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:EU}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g3, replace

// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 7
margins, dydx(public_change_nopart_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Redistribution}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g4, replace

// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 9
margins, dydx(public_change_nopart_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Social lifestyle}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g5, replace

// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 6
margins, dydx(public_change_nopart_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Environment}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g6, replace

// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag i.mainstream_narrow i.mainstream_narrow#c.public_change_supp_ees i.mainstream_narrow#c.public_change_nopart_ees if issue == 8
margins, dydx(public_change_nopart_ees) at(mainstream_narrow=(0 1)) atmeans asbalanced post 
coefplot, vertical ytitle("Predicted Δ party position") ///
title("{bf:Law and order}") yline(0, lpattern(shortdash)) ///
xlabel(,nolabels noticks nogrid) ylabel(-1.2 (0.2) 0.4) ///
mlabels(1._at = 3 "Niche" 2._at =  3 "Main") ciopts(lcolor(dknavy) lwidth(medthick)) replace levels(90)  legend(off) mlabposition(3) grid(none) msymbol(S) color(blue) 
graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((D) Δ Non-supporter, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige3d.png", replace

* Bischof nicheness index
* Figure E4 

set scheme plotplain
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 5

margins, dydx(supporter_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Immigration}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g2, replace
// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 1

margins, dydx(supporter_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:EU}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g3, replace
// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 7

margins, dydx(supporter_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Redistribution}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g4, replace
// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 9

margins, dydx(supporter_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Social lifestyle}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g5, replace
// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 6

margins, dydx(supporter_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Environment}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g6, replace
// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 8

margins, dydx(supporter_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Law and order}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((A) Supporter gap, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige4a.png", replace

set scheme plotplain
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 5

margins, dydx(nopart_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME non-supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Immigration}") level(90) yline(0) ///
yscale(r(-2 1)) ylabel(-2 (1) 1)

graph save g2, replace
// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 1

margins, dydx(nopart_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME non-supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:EU}") level(90) yline(0) ///
yscale(r(-2 1)) ylabel(-2 (1) 1)

graph save g3, replace
// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 7

margins, dydx(nopart_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME non-supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Redistribution}") level(90) yline(0) ///
yscale(r(-2 1)) ylabel(-2 (1) 1)

graph save g4, replace
// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 9

margins, dydx(nopart_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME non-supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Social lifestyle}") level(90) yline(0) ///
yscale(r(-2 1)) ylabel(-2 (1) 1)

graph save g5, replace
// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 6

margins, dydx(nopart_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME non-supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Environment}") level(90) yline(0) ///
yscale(r(-2 1)) ylabel(-2 (1) 1)

graph save g6, replace
// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.supporter_party_gap_lag c.mainstream_bischof#c.nopart_party_gap_lag if issue == 8

margins, dydx(nopart_party_gap_lag) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME non-supporter gap on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Law and order}") level(90) yline(0) ///
yscale(r(-2 1)) ylabel(-2 (1) 1)

graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((B) Non-supporter gap, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige4b.png", replace

set scheme plotplain
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 5

margins, dydx(public_change_supp_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Immigration}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g2, replace
// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 1

margins, dydx(public_change_supp_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:EU}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g3, replace
// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 7

margins, dydx(public_change_supp_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Redistribution}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g4, replace
// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 9

margins, dydx(public_change_supp_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Social lifestyle}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g5, replace
// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 6

margins, dydx(public_change_supp_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Environment}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g6, replace
// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 8

margins, dydx(public_change_supp_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Law and order}") level(90) yline(0) ///
yscale(r(-1 3)) ylabel(-1 (1) 3)

graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((C) Δ Supporter, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige4c.png", replace

set scheme plotplain
eststo clear

// Immigration
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 5

margins, dydx(public_change_nopart_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ non-supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Immigration}") level(90) yline(0) ///
yscale(r(-3 2)) ylabel(-3 (1) 2)

graph save g2, replace
// EU
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 1

margins, dydx(public_change_nopart_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ non-supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:EU}") level(90) yline(0) ///
yscale(r(-3 2)) ylabel(-3 (1) 2)

graph save g3, replace
// Redistribution
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 7

margins, dydx(public_change_nopart_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ non-supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Redistribution}") level(90) yline(0) ///
yscale(r(-3 2)) ylabel(-3 (1) 2)

graph save g4, replace
// Social lifestyle
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 9

margins, dydx(public_change_nopart_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ non-supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Social lifestyle}") level(90) yline(0) ///
yscale(r(-3 2)) ylabel(-3 (1) 2)

graph save g5, replace
// Environment
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 6

margins, dydx(public_change_nopart_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ non-supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Environment}") level(90) yline(0) ///
yscale(r(-3 2)) ylabel(-3 (1) 2)

graph save g6, replace
// Law and order
eststo: reg position_change public_change_supp_ees public_change_nopart_ees supporter_party_gap_lag nopart_party_gap_lag mainstream_bischof c.mainstream_bischof#c.public_change_supp_ees c.mainstream_bischof#c.public_change_nopart_ees if issue == 8

margins, dydx(public_change_nopart_ees) at(mainstream_bischof=(0(0.2)1))
marginsplot, ytitle(ME Δ non-supporter on Δ party position, size(small)) xtitle(Nicheness (Bischof 2017)) recast(line) recastci(rarea) ci1opt(fcolor(midblue%40) lcolor(midblue%40)) title("{bf:Law and order}") level(90) yline(0) ///
yscale(r(-3 2)) ylabel(-3 (1) 2)

graph save g7, replace

graph combine  "g2" "g3" "g4" "g5" "g6" "g7", col(3) title((D) Δ Non-supporter, margin(b=1) size(large)) caption("90% CIs", position(5) justification(right) size(vsmall))

graph export "fige4d.png", replace

* Appendix F
* Partisanship

* Figure F1

eststo clear
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 14
estimate store lr
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 5
estimate store imm
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 1
estimate store eu
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 7
estimate store redist
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 9
estimate store social
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 6
estimate store env
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 8
estimate store law

set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")) (law, aseq("Law and order")) || , keep(supporter2_party_gap_lag public_change_supp2_ees) ///
 swapnames eqlabels("{bf:Supporter gap}" "{bf:Δ Supporter}", angle(90)) ///
 aseq levels(90) ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position)  ///
 legend(off) mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))  mlabposition(12) grid(none) msymbol(s) color(blue) title("{bf:(A) Partisan constituency}", margin(b=5) size(med))

graph save "g1", replace

eststo clear
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 14
estimate store lr
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 5
estimate store imm
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 1
estimate store eu
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 7
estimate store redist
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 9
estimate store social
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 6
estimate store env
eststo: qui: reg position_change supporter2_party_gap_lag nopart2_party_gap_lag public_change_supp2_ees public_change_nopart2_ees if issue == 8
estimate store law

set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")) (law, aseq("Law and order")) || , keep(nopart2_party_gap_lag public_change_nopart2_ees) ///
 swapnames eqlabels("{bf:Non-supporter gap}" "{bf:Δ Non-supporter}", angle(90)) ///
 aseq levels(90) ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position)  ///
 legend(off) mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))  mlabposition(12) grid(none) msymbol(s) color(blue) title("{bf:(B) General electorate}", margin(b=5) size(med))

graph save "g2", replace 

graph combine "g1" "g2", caption("90% CIs; + p < 0.1, * p < 0.05, ** p < 0.01, *** p < 0.001", position(5) justification(right) size(vsmall))

graph export "figf1.png", replace


* Appendix G
* Jackknife years
* Figure G1
eststo clear
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 14 & year != 2010
estimate store lr
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 5 & year != 2010
estimate store imm
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 1 & year != 2010
estimate store eu
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 7 & year != 2010
estimate store redist
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 9 & year != 2010
estimate store social
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 6 & year != 2010
estimate store env
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 8 & year != 2010
estimate store law

eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 14 & year != 2014
estimate store lr2
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 5 & year != 2014
estimate store imm2
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 1 & year != 2014
estimate store eu2
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 7 & year != 2014
estimate store redist2
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 9 & year != 2014
estimate store social2
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 6 & year != 2014
estimate store env2
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 8 & year != 2014
estimate store law2

eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 14 & year != 2019
estimate store lr3
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 5 & year != 2019
estimate store imm3
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 1 & year != 2019
estimate store eu3
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 7 & year != 2019
estimate store redist3
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 9 & year != 2019
estimate store social3
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 6 & year != 2019
estimate store env3
*eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 8 & year != 2019
*estimate store law3

eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 14 & year != 2024
estimate store lr4
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 5 & year != 2024
estimate store imm4
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 1 & year != 2024
estimate store eu4
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 7 & year != 2024
estimate store redist4
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 9 & year != 2024
estimate store social4
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 6 & year != 2024
estimate store env4
eststo: qui: reg position_change voter_party_gap_lag public_change_ees if issue == 8 & year != 2024
estimate store law4

set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")), bylabel(no 2010)  || (lr2, aseq("Left-right")) (imm2, aseq("Immigration")) (eu2, aseq("EU")) (redist2, aseq("Redistribution")) (social2, aseq("Social")) (env2, aseq("Environment")), bylabel(no 2014) || (lr3, aseq("Left-right")) (imm3, aseq("Immigration")) (eu3, aseq("EU")) (redist3, aseq("Redistribution")) (social3, aseq("Social")) (env3, aseq("Environment")), bylabel(no 2019) || (lr4, aseq("Left-right")) (imm4, aseq("Immigration")) (eu4, aseq("EU")) (redist4, aseq("Redistribution")) (social4, aseq("Social")) (env4, aseq("Environment")), bylabel(no 2024) ||, keep(voter_party_gap_lag public_change_ees) ///
 swapnames eqlabels("{bf:Voter gap}" "{bf:Δ Voter}", angle(90)) ///
 aseq levels(90) ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position, size(medsmall))  ///
 mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))    mlabposition(12) byopts(cols(4) legend(off)) grid(none) msymbol(s) color(blue) subtitle(, bmargin(med))

graph save "g1", replace
graph combine "g1", caption("90% CIs; + p < 0.1, * p < 0.05, ** p < 0.01, *** p < 0.001", position(5) justification(right) size(vsmall))

graph export "figg1.png", replace

* Figure G2

eststo clear
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 14 & year != 2010
estimate store lr
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 5 & year != 2010
estimate store imm
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 1 & year != 2010
estimate store eu
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 7 & year != 2010
estimate store redist
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 9 & year != 2010
estimate store social
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 6 & year != 2010
estimate store env
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 8 & year != 2010
estimate store law

eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 14 & year != 2014
estimate store lr2
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 5 & year != 2014
estimate store imm2
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 1 & year != 2014
estimate store eu2
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 7 & year != 2014
estimate store redist2
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 9 & year != 2014
estimate store social2
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 6 & year != 2014
estimate store env2
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 8 & year != 2014
estimate store law2

eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 14 & year != 2019
estimate store lr3
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 5 & year != 2019
estimate store imm3
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 1 & year != 2019
estimate store eu3
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 7 & year != 2019
estimate store redist3
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 9 & year != 2019
estimate store social3
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 6 & year != 2019
estimate store env3
*eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 8 & year != 2019
*estimate store law3

eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 14 & year != 2024
estimate store lr4
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 5 & year != 2024
estimate store imm4
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 1 & year != 2024
estimate store eu4
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 7 & year != 2024
estimate store redist4
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 9 & year != 2024
estimate store social4
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 6 & year != 2024
estimate store env4
eststo: qui: reg position_change supporter_party_gap_lag nopart_party_gap_lag public_change_supp_ees public_change_nopart_ees if issue == 8 & year != 2024
estimate store law4
 
set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")), bylabel(no 2010)  || (lr2, aseq("Left-right")) (imm2, aseq("Immigration")) (eu2, aseq("EU")) (redist2, aseq("Redistribution")) (social2, aseq("Social")) (env2, aseq("Environment")), bylabel(no 2014) || (lr3, aseq("Left-right")) (imm3, aseq("Immigration")) (eu3, aseq("EU")) (redist3, aseq("Redistribution")) (social3, aseq("Social")) (env3, aseq("Environment")), bylabel(no 2019) || (lr4, aseq("Left-right")) (imm4, aseq("Immigration")) (eu4, aseq("EU")) (redist4, aseq("Redistribution")) (social4, aseq("Social")) (env4, aseq("Environment")), bylabel(no 2024) ||, keep(supporter_party_gap_lag nopart_party_gap_lag) ///
 swapnames eqlabels("{bf:Supporter gap}" "{bf:Non-supporter gap}", angle(90)) ///
 aseq levels(90) ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position, size(medsmall))  ///
 mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))    mlabposition(12) byopts(cols(4) legend(off)) grid(none) msymbol(s) color(blue) subtitle(, bmargin(med))

graph save "g1", replace 


set scheme plotplain
coefplot (lr, aseq("Left-right")) (imm, aseq("Immigration")) (eu, aseq("EU")) (redist, aseq("Redistribution")) (social, aseq("Social")) (env, aseq("Environment")), bylabel(no 2010)  || (lr2, aseq("Left-right")) (imm2, aseq("Immigration")) (eu2, aseq("EU")) (redist2, aseq("Redistribution")) (social2, aseq("Social")) (env2, aseq("Environment")), bylabel(no 2014) || (lr3, aseq("Left-right")) (imm3, aseq("Immigration")) (eu3, aseq("EU")) (redist3, aseq("Redistribution")) (social3, aseq("Social")) (env3, aseq("Environment")), bylabel(no 2019) || (lr4, aseq("Left-right")) (imm4, aseq("Immigration")) (eu4, aseq("EU")) (redist4, aseq("Redistribution")) (social4, aseq("Social")) (env4, aseq("Environment")), bylabel(no 2024) ||, keep(public_change_supp_ees public_change_nopart_ees) ///
 swapnames eqlabels("{bf:Δ Supporter}" "{bf:Δ Non-supporter}", angle(90)) ///
 aseq levels(90) ciopts(lcolor(dknavy)) xline(0) xtitle(Δ Party position, size(medsmall))  ///
 mlabel(cond(@pval<.001, string(@b, "%9.2fc") + "***", cond(@pval<.01, string(@b, "%9.2fc") + "**" , cond(@pval<.05, string(@b, "%9.2fc") + "*"  , cond(@pval<.1, string(@b, "%9.2fc") + "+", string(@b, "%9.2fc"))))))    mlabposition(12) byopts(cols(4) legend(off)) grid(none) msymbol(s) color(blue) subtitle(, bmargin(med)) 

graph save "g2", replace

graph combine "g1" "g2", caption("90% CIs; + p < 0.1, * p < 0.05, ** p < 0.01, *** p < 0.001", position(5) justification(right) size(vsmall))

graph export "figg2.png", replace



